<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'db.php';
include 'functions.php';

try {
    $stmt = $pdo->prepare("SELECT id, login_username, wallet_balance FROM users");
    $stmt->execute();
    $users = $stmt->fetchAll();

    $today = date('Y-m-d');
    $yesterday = date('Y-m-d', strtotime('-1 day'));
    $last_week = date('Y-m-d', strtotime('-1 week'));
    $last_month = date('Y-m-d', strtotime('-1 month'));

    $summary = [];

    foreach ($users as $user) {
        $user_id = $user['id'];

        $summary[$user_id] = [
            'username' => $user['login_username'],
            'wallet_balance' => $user['wallet_balance'],
            'today' => getTotalAmount($pdo, $user_id, $today),
            'yesterday' => getTotalAmount($pdo, $user_id, $yesterday),
            'last_week' => getTotalAmount($pdo, $user_id, $last_week),
            'last_month' => getTotalAmount($pdo, $user_id, $last_month),
            'total' => getTotalAmount($pdo, $user_id)
        ];
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit();
}

function getTotalAmount($pdo, $user_id, $start_date = null) {
    $query = "SELECT SUM(amount_deducted) FROM logs WHERE user_id = ?";
    $params = [$user_id];

    if ($start_date) {
        $query .= " AND DATE(created_at) >= ?";
        $params[] = $start_date;
    }

    $stmt = $pdo->prepare($query);
    $stmt->execute($params);
    return $stmt->fetchColumn();
}

// ایجاد پیام تلگرام
$message = "گزارش کلی کاربران:\n";
foreach ($summary as $user) {
    $message .= "🔸 نام کاربر: #" . $user['username'] . "\n";
    $message .= "💰 موجودی کیف پول: " . number_format($user['wallet_balance']) . " تومان\n";
    $message .= "🟢 سفارشات امروز: " . number_format($user['today']) . " تومان\n";
    $message .= "🔵 سفارشات دیروز: " . number_format($user['yesterday']) . " تومان\n";
    $message .= "🟠 سفارشات یک هفته: " . number_format($user['last_week']) . " تومان\n";
    $message .= "🟣 سفارشات یک ماه: " . number_format($user['last_month']) . " تومان\n";
    $message .= "🔴 سفارشات کل: " . number_format($user['total']) . " تومان\n";
    $message .= "------------------------\n";
}

// ارسال پیام تلگرام
sendTelegramMessage($message);
?>
