<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

include 'db.php';
include 'functions.php';

if (!isset($_SESSION['user'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not authenticated']);
    exit();
}

$user = $_SESSION['user'];
$base_url = $user['panel_url'];
$admin_username = $user['panel_username'];
$admin_password = $user['panel_password'];
$admin_login_username = $user['login_username']; // فرض می‌کنیم login_username در سشن ذخیره شده است

$external_servername = "147.45.138.167";
$external_port = 3306;
$external_username = "root";
$external_password = "M435fdg546Fgfh";
$external_dbname = "marzban";

try {
    $dsn = "mysql:host=$external_servername;port=$external_port;dbname=$external_dbname;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];
    $external_pdo = new PDO($dsn, $external_username, $external_password, $options);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Failed to connect to external database: ' . $e->getMessage()]);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $extra_data_limit_gb = intval($_POST['data_limit']);
    $extra_data_limit = $extra_data_limit_gb * 1024 * 1024 * 1024;

    // دریافت تاریخ انقضا از دیتابیس خارجی
    $stmt = $external_pdo->prepare("SELECT expire FROM users WHERE username = :username");
    $stmt->execute(['username' => $username]);
    $expire = $stmt->fetchColumn();

    if (!$expire) {
        echo json_encode(['status' => 'error', 'message' => 'User not found']);
        exit();
    }

    // محاسبه مدت زمان باقی‌مانده
    $expire_time = intval($expire);
    $current_time = time();
    $remaining_seconds = $expire_time - $current_time;
    $remaining_days = ceil($remaining_seconds / (60 * 60 * 24));

    // تنظیم قیمت هر گیگابایت بر اساس مدت زمان باقی‌مانده
    if ($remaining_days <= 32) {
        $cost_per_gb = 1000;
    } elseif ($remaining_days <= 63) {
        $cost_per_gb = 2000;
    } else {
        $cost_per_gb = 3000;
    }

    $total_cost = $extra_data_limit_gb * $cost_per_gb;
    $gift_percentage = 0.05;
    $gift_amount = $total_cost * $gift_percentage;

    $stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
    $stmt->execute(['user_id' => $user['id']]);
    $wallet_balance = $stmt->fetchColumn();

    if ($wallet_balance >= $total_cost) {
        $new_wallet_balance = $wallet_balance - $total_cost + $gift_amount;

        $stmt = $pdo->prepare("UPDATE users SET wallet_balance = :new_wallet_balance WHERE id = :user_id");
        $stmt->execute(['new_wallet_balance' => $new_wallet_balance, 'user_id' => $user['id']]);

        $_SESSION['user']['wallet_balance'] = $new_wallet_balance;

        $result = buy_extra_data($base_url, $admin_username, $admin_password, $username, $extra_data_limit);

        if ($result) {
            $stmt = $pdo->prepare("INSERT INTO logs (user_id, action, description, current_balance, new_balance, amount_deducted, data_volume, expire_time, user_status) VALUES (:user_id, 'buy_extra_data', :description, :current_balance, :new_balance, :amount_deducted, :data_volume, 0, 'active')");
            $stmt->execute([
                'user_id' => $user['id'],
                'description' => 'Extra data bought for username: ' . $username . '. Gift amount returned to wallet: ' . number_format($gift_amount, 0, '', ','),
                'current_balance' => $wallet_balance,
                'new_balance' => $new_wallet_balance,
                'amount_deducted' => $total_cost,
                'data_volume' => $extra_data_limit
            ]);

            // ارسال پیام به تلگرام
            $statusEmoji = '✅';
            $message = "#buy_extra_data\n"; // اضافه کردن هشتگ در ابتدای پیام
            $message .= "🔔 <b>Action:</b> Buy Extra Data\n";
            $message .= "👤 <b>Admin:</b> #" . $admin_login_username . "\n";
            $message .= "👤 <b>Username:</b> #" . $username . "\n";
            $message .= "💰 <b>Current Balance:</b> " . number_format($wallet_balance, 0, '', ',') . "\n";
            $message .= "💳 <b>New Balance:</b> " . number_format($new_wallet_balance, 0, '', ',') . "\n";
            $message .= "💸 <b>Amount Deducted:</b> " . number_format($total_cost, 0, '', ',') . "\n";
            $message .= "📊 <b>Extra Data Volume:</b> " . number_format($extra_data_limit_gb, 0) . " GB\n";
            $message .= "🎁 <b>Gift Amount:</b> " . number_format($gift_amount, 0, '', ',') . "\n";
            $message .= "🔒 <b>User Status:</b> " . $statusEmoji . "\n";
            $message .= "⏰ <b>Purchased At:</b> " . date('Y-m-d H:i:s') . "\n";
            $message .= "📝 <b>Description:</b> Extra data bought for username: " . $username . "\n";

            sendTelegramMessage($message);

            // ارسال پیغام موفقیت به صورت JSON
            echo json_encode([
                'status' => 'success',
                'message' => "حجم اضافه با موفقیت ثبت شد<br><small> مبلغ " . number_format($gift_amount, 0, '', ',') . " تومان به کیف پول شما اضافه شد 🎁😊</small>",
                'remaining_days' => $remaining_days, // نمایش تعداد روزهای باقی‌مانده در خروجی JSON
                'total_cost' => $total_cost // نمایش هزینه کل در خروجی JSON
            ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to buy extra data']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'موجودی کافی نیست']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}


?>
