<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_username = $_POST['login_username'];
    $login_password = $_POST['login_password'];
    $last_name = $_POST['last_name'];
    $panel_username = $_POST['panel_username'];
    $panel_password = $_POST['panel_password'];
    $panel_url = $_POST['panel_url'];
    $wallet_balance = $_POST['wallet_balance'];

    // هش کردن پسورد لاگین
    $login_password_hashed = password_hash($login_password, PASSWORD_DEFAULT);

    // ذخیره پسورد پنل به صورت plain text
    $stmt = $pdo->prepare("INSERT INTO users (login_username, login_password, last_name, panel_username, panel_password, panel_url, wallet_balance) VALUES (:login_username, :login_password, :last_name, :panel_username, :panel_password, :panel_url, :wallet_balance)");
    $stmt->execute([
        'login_username' => $login_username,
        'login_password' => $login_password_hashed,
        'last_name' => $last_name,
        'panel_username' => $panel_username,
        'panel_password' => $panel_password,
        'panel_url' => $panel_url,
        'wallet_balance' => $wallet_balance
    ]);

    $message = "User created successfully.";
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>ساخت کاربر جدید</title>
    <link rel="stylesheet" type="text/css" href="styles.css">
</head>
<body>
    <h1>ساخت کاربر جدید</h1>
    <?php if (!empty($message)) { echo "<p>$message</p>"; } ?>
    <form method="post" action="">
        <label for="login_username">نام کاربری لاگین:</label><br>
        <input type="text" id="login_username" name="login_username" required><br>
        <label for="login_password">رمز عبور لاگین:</label><br>
        <input type="password" id="login_password" name="login_password" required><br>
        <label for="last_name">نام خانوادگی:</label><br>
        <input type="text" id="last_name" name="last_name" required><br>
        <label for="panel_username">نام کاربری پنل:</label><br>
        <input type="text" id="panel_username" name="panel_username" required><br>
        <label for="panel_password">رمز عبور پنل:</label><br>
        <input type="password" id="panel_password" name="panel_password" required><br>
        <label for="panel_url">آدرس پنل:</label><br>
        <input type="text" id="panel_url" name="panel_url" required><br>
        <label for="wallet_balance">موجودی کیف پول:</label><br>
        <input type="number" id="wallet_balance" name="wallet_balance" required><br><br>
        <input type="submit" value="ساخت کاربر">
    </form>
</body>
</html>
