<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not authenticated']);
    exit();
}

include 'db.php'; // اتصال به دیتابیس
include 'functions.php'; // وارد کردن سایر توابع

$user = $_SESSION['user'];
$base_url = $user['panel_url'];
$admin_username = $user['panel_username'];
$admin_password = $user['panel_password'];
$admin_login_username = $user['login_username']; // فرض می‌کنیم login_username در سشن ذخیره شده است

$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user['id']]);
$wallet_balance = $stmt->fetchColumn();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $test_cost = 1000; // هزینه ساخت اکانت تست
    if ($wallet_balance < $test_cost) {
        echo json_encode(['status' => 'error', 'message' => 'موجودی کافی نیست']);
        exit();
    }

    // پیدا کردن یوزرنیم تکراری با استفاده از عدد تصادفی 4 رقمی
    do {
        $random_number = rand(1000, 9999);
        $test_username = $admin_login_username . '_test_' . $random_number;
        $stmt = $pdo->prepare("SELECT COUNT(*) FROM users WHERE login_username = :username");
        $stmt->execute(['username' => $test_username]);
        $count = $stmt->fetchColumn();
    } while ($count > 0);

    // ایجاد اکانت تست
    $data_limit = 1024 * 1024 * 1024; // 1024 مگابایت
    $expire = strtotime("+1 day"); // یک روز

    $new_user_data = array(
        "username" => $test_username,
        "data_limit" => $data_limit,
        "expire" => $expire,
        "proxies" => array("vless" => array(), "vmess" => array())
    );

    $response = add_user($base_url, $admin_username, $admin_password, $new_user_data);
    if ($response) {
        // کسر موجودی از پنل
        $new_wallet_balance = $wallet_balance - $test_cost;
        $stmt = $pdo->prepare("UPDATE users SET wallet_balance = :new_wallet_balance WHERE id = :user_id");
        $stmt->execute(['new_wallet_balance' => $new_wallet_balance, 'user_id' => $user['id']]);

        // به‌روزرسانی مقدار wallet_balance در سشن
        $_SESSION['user']['wallet_balance'] = $new_wallet_balance;

        // ثبت لاگ
        $stmt = $pdo->prepare("INSERT INTO logs (user_id, action, description, current_balance, new_balance, amount_deducted, data_volume, expire_time, user_status) VALUES (:user_id, 'create_test_account', :description, :current_balance, :new_balance, :amount_deducted, :data_volume, :expire_time, :user_status)");
        $stmt->execute([
            'user_id' => $user['id'],
            'description' => 'Test account created with username: ' . $test_username,
            'current_balance' => $wallet_balance,
            'new_balance' => $new_wallet_balance,
            'amount_deducted' => $test_cost,
            'data_volume' => $data_limit,
            'expire_time' => $expire,
            'user_status' => 'active'
        ]);

        // ارسال پیام به تلگرام
        $statusEmoji = '✅';
        $message = "#create_test\n"; // اضافه کردن هشتگ در ابتدای پیام
        $message .= "🔔 <b>ID:</b> " . $pdo->lastInsertId() . "\n";
        $message .= "👤 <b>Created By Admin:</b> #" . $admin_login_username . "\n";
        $message .= "👤 <b>Username:</b> #" . $test_username . "\n";
        $message .= "⚙️ <b>Action:</b> create_test_account\n";
        $message .= "💰 <b>Current Balance:</b> " . number_format($wallet_balance, 0, '', ',') . "\n";
        $message .= "💳 <b>New Balance:</b> " . number_format($new_wallet_balance, 0, '', ',') . "\n";
        $message .= "💸 <b>Amount Deducted:</b> " . number_format($test_cost, 0, '', ',') . "\n";
        $message .= "📊 <b>Data Volume:</b> " . number_format($data_limit / (1024 * 1024 * 1024), 0) . " GB\n";
        $message .= "📅 <b>Expire Time:</b> " . date('Y-m-d H:i:s', $expire) . "\n";
        $message .= "🔒 <b>User Status:</b> " . $statusEmoji . "\n";
        $message .= "⏰ <b>Created At:</b> " . date('Y-m-d H:i:s') . "\n";
        $message .= "📝 <b>Description:</b> Test account created with username: " . $test_username . "\n";

        sendTelegramMessage($message);

        echo json_encode([
            'status' => 'success',
            'message' => 'اکانت تست با موفقیت ساخته شد. مبلغ 1000 تومان بابت ساخت اکانت تست از شما کسر شد.'
        ]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create test account']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
