<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not authenticated']);
    exit();
}

include 'db.php'; // اتصال به دیتابیس
include 'functions.php'; // وارد کردن سایر توابع

$user = $_SESSION['user'];
$base_url = $user['panel_url'];
$admin_username = $user['panel_username'];
$admin_password = $user['panel_password'];
$admin_login_username = $user['login_username']; // فرض می‌کنیم login_username در سشن ذخیره شده است

$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user['id']]);
$wallet_balance = $stmt->fetchColumn();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $data_limit_gb = $_POST['data_limit_gb'];
    $expire_months = $_POST['expire_months'];

    // اضافه کردن یک عدد رندوم ۵ رقمی به انتهای یوزرنیم
    $random_number = rand(10000, 99999);
    $username .= '_' . $random_number;

    $data_limit = $data_limit_gb * 1024 * 1024 * 1024;
    $expire = strtotime("+$expire_months months");

    // جدول قیمت‌ها برای سه پلن مشخص
    $pricing_table = [
        10 => [
            1 => 20000, // 10 گیگابایت، 1 ماه، 20000 تومان
            2 => 40000, // 10 گیگابایت، 2 ماه، 40000 تومان
            3 => 60000, // 10 گیگابایت، 3 ماه، 60000 تومان
        ],
        20 => [
            1 => 25000, // 20 گیگابایت، 1 ماه، 25000 تومان
            2 => 50000, // 20 گیگابایت، 2 ماه، 50000 تومان
            3 => 75000, // 20 گیگابایت، 3 ماه، 75000 تومان
        ],
    ];

    if (isset($pricing_table[$data_limit_gb][$expire_months])) {
        $total_cost = $pricing_table[$data_limit_gb][$expire_months];
    } else {
        // فرمول محاسبه هزینه برای موارد دیگر
        $cost_per_gb_per_month = 1000;
        $total_cost = $data_limit_gb * $cost_per_gb_per_month * $expire_months;
    }

    $gift_percentage = 0.05;
    $gift_amount = $total_cost * $gift_percentage;

    // بررسی موجودی کاربر
    if ($wallet_balance >= $total_cost) {
        $new_wallet_balance = $wallet_balance - $total_cost + $gift_amount;

        // به‌روزرسانی موجودی کیف پول با استفاده از PDO
        $stmt = $pdo->prepare("UPDATE users SET wallet_balance = :new_wallet_balance WHERE id = :user_id");
        $stmt->execute(['new_wallet_balance' => $new_wallet_balance, 'user_id' => $user['id']]);

        // به‌روزرسانی مقدار wallet_balance در سشن
        $_SESSION['user']['wallet_balance'] = $new_wallet_balance;

        // ایجاد کاربر جدید
        $new_user_data = array(
            "username" => $username,
            "data_limit" => $data_limit,
            "expire" => $expire,
            "proxies" => array("vless" => array(), "vmess" => array())
        );

        $response = add_user($base_url, $admin_username, $admin_password, $new_user_data);
        if ($response) {
            $stmt = $pdo->prepare("INSERT INTO logs (user_id, action, description, current_balance, new_balance, amount_deducted, data_volume, expire_time, user_status) VALUES (:user_id, 'create_user', :description, :current_balance, :new_balance, :amount_deducted, :data_volume, :expire_time, :user_status)");
            $stmt->execute([
                'user_id' => $user['id'],
                'description' => 'User created with username: ' . $username,
                'current_balance' => $wallet_balance,
                'new_balance' => $new_wallet_balance,
                'amount_deducted' => $total_cost,
                'data_volume' => $data_limit,
                'expire_time' => $expire,
                'user_status' => 'active'
            ]);

            // ارسال پیام به تلگرام
            $statusEmoji = '✅';
            $message = "#create_account\n"; // اضافه کردن هشتگ در ابتدای پیام
            $message .= "🔔 <b>ID:</b> " . $pdo->lastInsertId() . "\n";
            $message .= "👤 <b>Created By Admin:</b> #" . $admin_login_username . "\n";
            $message .= "👤 <b>Username:</b> #" . $username . "\n";
            $message .= "⚙️ <b>Action:</b> create_user\n";
            $message .= "💰 <b>Current Balance:</b> " . number_format($wallet_balance, 0, '', ',') . "\n";
            $message .= "💳 <b>New Balance:</b> " . number_format($new_wallet_balance, 0, '', ',') . "\n";
            $message .= "💸 <b>Amount Deducted:</b> " . number_format($total_cost, 0, '', ',') . "\n";
            $message .= "🎁 <b>Gift Amount:</b> " . number_format($gift_amount, 0, '', ',') . "\n";
            $message .= "📊 <b>Data Volume:</b> " . number_format($data_limit / (1024 * 1024 * 1024), 0) . " GB\n";
            $message .= "📅 <b>Expire Time:</b> " . date('Y-m-d H:i:s', $expire) . "\n";
            $message .= "🔒 <b>User Status:</b> " . $statusEmoji . "\n";
            $message .= "⏰ <b>Created At:</b> " . date('Y-m-d H:i:s') . "\n";
            $message .= "📝 <b>Description:</b> User created with username: " . $username . "\n";

            sendTelegramMessage($message);

            echo json_encode([
                'status' => 'success',
'message' => "موفقیت آمیز بود<br><small> مبلغ " . number_format($total_cost, 0, '', ',') . " تومان از کیف پول کسر شد<br> مبلغ " . number_format($gift_amount, 0, '', ',') . " تومان هم بعنوان هدیه به کیف پول شما بازگشت 🎁😊</small>"
                       ]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Failed to create user']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'موجودی کافی نیست']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}
?>
