<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}





if (!isset($_SESSION['user'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not logged in']);
    exit();
}

include 'db.php';

$user = $_SESSION['user'];
$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user['id']]);
$wallet_balance = $stmt->fetchColumn();

if ($wallet_balance !== false) {
    echo json_encode(['status' => 'success', 'wallet_balance' => number_format($wallet_balance, 0, '', ',')]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Failed to retrieve wallet balance']);
}
?>
