<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}





if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}




// تنظیم تایمر اکسپایر کردن سشن به 20 دقیقه
if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY'] > 1200)) {
    session_unset();
    session_destroy();
    header('Location: login.php');
    exit();
}
$_SESSION['LAST_ACTIVITY'] = time();

include 'db.php'; // اتصال به دیتابیس
include 'functions.php'; // وارد کردن سایر توابع

$user = $_SESSION['user'];
$base_url = $user['panel_url'];
$admin_username = $user['panel_username'];
$admin_password = $user['panel_password'];
$last_name = $user['last_name'];

// دریافت موجودی به‌روز شده از دیتابیس
$stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
$stmt->execute(['user_id' => $user['id']]);
$wallet_balance = $stmt->fetchColumn();

$message = "";
$edit_user_data = null;
$alert = null;













?>
<!DOCTYPE html>
<html lang="fa">
<head>
<meta charset="UTF-8">
    <title>لیست کاربران</title>
    <link rel="stylesheet" href="styles.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    
    <script src="https://cdn.jsdelivr.net/npm/darkmode-js@1.5.7/lib/darkmode-js.min.js"></script>




    <style>
      /* Add this CSS code to your stylesheet */
@media (max-width: 768px) {
    .mob {
        display: block;
        width: 100%;
        margin-bottom: 10px;
    }
    .usage20{
        
        
       width: 15%;
    }
    .table-responsive {
        overflow-x: auto;
    }

    #usersTable th, #usersTable td {
        white-space: nowrap;
    }
}
    
        label,.modal-title,.modal-body{
            color: black;
        }
        .farsi {
            direction: rtl;
            float: right;
        }
        body {
            background-color: #2c2f33;
            color: #fff;
            font-family: 'IRANSans', sans-serif;
        }
        .status-icon {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
        }
        .status-online {
            background-color: green;
            animation: pulse 1s infinite;
        }
        .status-never-connected {
            background-color: orange;
        }
        .status-offline {
            background-color: red;
        }
        @keyframes pulse {
            0% {
                transform: scale(0.9);
            }
            70% {
                transform: scale(1);
                box-shadow: 0 0 5px rgba(0, 255, 0, 0.7);
            }
            100% {
                transform: scale(0.9);
            }
        }
        .action-btn {
            color: #fff;
            background-color: #7289da;
            border: none;
            padding: 5px 10px;
            border-radius: 3px;
            cursor: pointer;
        }
        .action-btn:hover {
            background-color: #677bc4;
        }
        td.text-rtl {
            direction: rtl;
            text-align: left;
        }
        .progress {
            height: 10px;
            margin-top: 5px;
            background-color: #4e5d6c;
        }
        .progress-bar {
            background-color: #7289da;
        }
        .circle {
            display: inline-block;
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 5px;
        }
        .pulse {
            animation: pulse 1s infinite;
        }
        .green {
            background-color: green;
        }
        .red {
            background-color: red;
        }
        .orange {
            background-color: orange;
        }
        @keyframes pulse {
            0% {
                transform: scale(0.9);
                opacity: 0.7;
            }
            70% {
                transform: scale(1);
                opacity: 1;
            }
            100% {
                transform: scale(0.9);
                opacity: 0.7;
            }
        }
        .status-badge {
            display: inline-block;
            padding: 5px 10px;
            color: white;
            border-radius: 15px;
            width: fit-content;
            text-align: center;
        }
        .status-active {
            background-color: #28a745; /* رنگ سبز */
        }
        .status-disabled {
            background-color: #dc3545; /* رنگ قرمز */
        }
        small.custom-style {
            font-size: 0.875em; /* فونت ریزتر */
            color: #A0AEC0; /* رنگ متن */
            margin-left: 10px; /* فاصله از سمت چپ */
        }
        .header {
            background-color: #1e1e1e;
            color: #e0e0e0;
            padding: 1rem;
            border-radius: 0.5rem;
        }
        .header h2, .header p {
            margin: 0;
        }
        .header .flex-grow-1 {
            flex-grow: 1;
        }
        .header .actions {
            margin-left: auto;
        }
        .pagination {
            display: flex;
            justify-content: center;
            padding: 1rem;
        }
        .page-item.active .page-link {
            background-color: #007bff;
            border-color: #007bff;
        }
        .modal-backdrop {
            z-index: 0 !important;
        }
        
         #priceTable, #rulesText {
            display: none;
        }
        
             .modal-body table {
            direction: rtl;
            text-align: right;
        }
        .modal-body table th,.modal-body table td {
            text-align: right;
        }
               .rules-list {
            direction: rtl;
            text-align: right;
        }
        .rules-list li {
            margin-bottom: 10px;
        }
        

}
    </style>
</head>




<body class="dark-mode">
    
    
    <!-- Image and text -->
<nav class="navbar navbar-light bg-light">

  <a class="navbar-brand" href="#">
    <img src="icon2.png" width="30" height="30" class="d-inline-block align-top" alt="فری دریم">
    FreeDreamPanel
<span class="badge badge-pill badge-primary">فری دریم</span>
  </a>
  
  
  
  

  


  
  
  
</nav>
    
    <div style="text-align:center;" class="alert alert-success" role="alert">
🎁🍉 پنج درصد از مبلغ ساخت اکانت جدید ، تمدید اکانت ، خرید حجم اضافی  بعد از خرید به صورت اتوماتیک به کیف پول شما برمیگردد
</div>
    
    
    
    <div class="container-fluid mt-4">
        
        
        
        
        
        
         <div class="header mb-4 d-flex align-items-center">
            <div class="mr-3">
                
                <button class="btn btn-secondary mr-2" data-toggle="modal" data-target="#priceTableModal">تعرفه ها</button>
                <button class="btn btn-secondary mr-2" data-toggle="modal" data-target="#rulesModal">قوانین پنل</button>


                <form method="post" action="logout.php" style="display:inline;">
                    <input type="submit" name="logout" value="خروج" class="btn btn-danger">
                </form>
            </div>
            <div class="flex-grow-1 text-center">
                <p>موجودی پنل: <span id="walletBalance"><?php echo number_format($wallet_balance, 0, '', ','); ?></span> تومان</p>
            </div>
            <div class="actions d-flex">
                <h3>آقای <?php echo htmlspecialchars($last_name); ?> به پنل خوش آمدید</h3>
            </div>
        </div>

        <button class="btn farsi btn-primary mb-3" data-toggle="modal" data-target="#createModal">ساخت کاربر جدید</button>
        <p></p>
        <button style="margin-right:5px;" class="btn farsi btn-warning mb-3" data-toggle="modal" onclick="loadTable()">بروز رسانی لیست</button>

        <button style="margin-right:5px;" class="btn farsi btn-success mb-3" id="createTestAccountBtn">ساخت اکانت تست</button>



        <div class="table-responsive rounded">
            <table id="usersTable" class="table rounded table-striped table-dark w-100">
                <thead>
                    <tr>
            <th style="width: 20%;">نام کاربری</th>
            <th style="width: 15%;">وضعیت</th>
            <th class="usage20">مصرف</th>
            <th style="width: 10%;">لینک اشتراک</th>
            <th style="width: 20%;">عملیات</th>
                    </tr>
                </thead>
                <tbody id="tableBody">
                    <!-- محتوای جدول با استفاده از AJAX بارگذاری می‌شود -->
                </tbody>
            </table>
            <div class="pagination" id="pagination">
                <!-- لینک‌های صفحه‌بندی با استفاده از AJAX بارگذاری می‌شوند -->
            </div>
        </div>
    </div>



<!-- Modal برای جدول تعرفه‌ها -->
<div class="modal fade" id="priceTableModal" tabindex="-1" role="dialog" aria-labelledby="priceTableModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="priceTableModalLabel">جدول تعرفه‌ها</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>نام عملیات</th>
                            <th>حجم (GB)</th>
                            <th>قیمت یک ماهه</th>
                            <th>قیمت دو ماهه</th>
                            <th>قیمت سه ماهه</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- ردیف‌های ثابت برای ساخت یوزر و تمدید -->
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>10</td>
                            <td>20,000</td>
                            <td>40,000</td>
                            <td>60,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>20</td>
                            <td>25,000</td>
                            <td>50,000</td>
                            <td>75,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>30</td>
                            <td>30,000</td>
                            <td>60,000</td>
                            <td>90,000</td>
                        </tr>
                        <!-- ردیف‌های محاسبه شده برای ساخت یوزر و تمدید از 40 گیگ تا 100 گیگ -->
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>40</td>
                            <td>40,000</td>
                            <td>80,000</td>
                            <td>120,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>50</td>
                            <td>50,000</td>
                            <td>100,000</td>
                            <td>150,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>60</td>
                            <td>60,000</td>
                            <td>120,000</td>
                            <td>180,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>70</td>
                            <td>70,000</td>
                            <td>140,000</td>
                            <td>210,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>80</td>
                            <td>80,000</td>
                            <td>160,000</td>
                            <td>240,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>90</td>
                            <td>90,000</td>
                            <td>180,000</td>
                            <td>270,000</td>
                        </tr>
                        <tr>
                            <td>ساخت یوزر و تمدید</td>
                            <td>100</td>
                            <td>100,000</td>
                            <td>200,000</td>
                            <td>300,000</td>
                        </tr>
                        <!-- خرید حجم مازاد -->
                        <tr>
                            <td>خرید هر گیگ حجم مازاد</td>
                            <td>1</td>
                            <td>1,000</td>
                            <td>2,000</td>
                            <td>3,000</td>
                        </tr>
                    </tbody>
                </table>
                <div class="text-danger mt-3 text-right">
                    تمام قیمت ها به تومان می باشد<br>
                    قیمت های پنل از 30 تا 100 گیگ، گیگی هزار تومن برای یک ماهه حساب می شود <br>
                    پلن های 10 و 20 گیگ فقط برای افراد خاصی که تمایل دارند وجود دارد و قیمت آنها متفاوت است <br> 
ترجیحا شما اکانت 30 گیگ به بالا تهیه کنید که بصرفه باشد<br>

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
            </div>
        </div>
    </div>
</div>


    <!-- Modal برای قوانین -->
    <div class="modal fade" id="rulesModal" tabindex="-1" role="dialog" aria-labelledby="rulesModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="rulesModalLabel">قوانین پنل</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    
                       <div class="card-body">
                <ul class="list-group rules-list">
                    <li class="list-group-item">۱- ساخت اکانت، تمدید اکانت، خرید حجم اضافه برای اکانت‌ها قابل حذف یا قابل ریفاند نمی‌باشد.</li>
                    <li class="list-group-item">۲- مبلغ هر عملیات مطابق تعرفه‌ها از موجودی کیف پول شما کسر می‌گردد.</li>
                    <li class="list-group-item">۳- پنج درصد از هر تراکنش در پنل بعنوان هدیه به کیف پول پنل شما بازگشت داده می‌شود.</li>
                    <li class="list-group-item">۴- امکان ساخت اکانت تست برای مشتری در پنل وجود ندارد.</li>
                    <li class="list-group-item">۵- این قوانین در آینده آپدیت می‌شود.</li>
                                        <li class="list-group-item">  امکان حذف اکانت خریداری شده وجود ندارد </li>

                </ul>
            </div>
                 
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>


    <!-- Modal -->
    <div id="detailsModal" class="modal fade" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title">User Details</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <p><strong>Sub Revoked At:</strong> <span id="modalSubRevokedAt"></span></p>
            <p><strong>Note:</strong> <span id="modalNote"></span></p>
            <p><strong>Sub Updated At:</strong> <span id="modalSubUpdatedAt"></span></p>
            <p><strong>Sub Last User Agent:</strong> <span id="modalSubLastUserAgent"></span></p>
            <p><strong>Online At:</strong> <span id="modalOnlineAt"></span></p>
            <p><strong>Expire:</strong> <span id="modalExpire"></span></p>
            <p><strong>Created At:</strong> <span id="modalCreatedAt"></span></p>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          </div>
        </div>
      </div>
    </div>

    
    
    <!-- Create User Modal -->
<div class="modal fade" id="createModal" tabindex="-1" role="dialog" aria-labelledby="createModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createModalLabel">ساخت کاربر جدید</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form id="createUserForm">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="username">نام کاربری:</label>
                        <input type="text" id="username" name="username" class="form-control" required pattern="^[a-zA-Z0-9_]{3,29}$" title="Username must be 3-29 characters long and can contain a-z, 0-9, and underscores.">
                    </div>
                    <div class="form-group">
                        <label for="data_limit_gb">حجم (GB):</label>
                        <select id="data_limit_gb" name="data_limit_gb" class="form-control" required>
                            <?php for ($i = 10; $i <= 100; $i += 10) { ?>
                                <option value="<?php echo $i; ?>"><?php echo $i; ?> GB</option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="expire_months">مدت زمان انقضا:</label>
                        <select id="expire_months" name="expire_months" class="form-control" required>
                            <option value="1">یک ماه</option>
                            <option value="2">دو ماه</option>
                            <option value="3">سه ماه</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                    <button type="submit" class="btn btn-primary">ایجاد کاربر</button>
                </div>
            </form>
        </div>
    </div>
</div>

    
    
    
    
    

    <!-- Loader -->
    <div id="loader" style="display:none;">Loading...</div>

    <!-- Edit User Modal -->
    <div class="modal fade" id="editModal" tabindex="-1" role="dialog" aria-labelledby="editModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editModalLabel">ویرایش کاربر</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form method="post" action="">
                    <div class="modal-body">
                        <input type="hidden" id="update_username" name="update_username">
                        <div class="form-group">
                            <label for="update_data_limit_gb">حجم (GB):</label>
                            <input type="number" id="update_data_limit_gb" name="update_data_limit_gb" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label for="update_expire">تاریخ انقضا (UTC):</label>
                            <input type="datetime-local" id="update_expire" name="update_expire" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                        <button type="submit" name="update_user" class="btn btn-primary">به‌روزرسانی کاربر</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Renew User Modal -->
    <div class="modal fade" id="renewModal" tabindex="-1" role="dialog" aria-labelledby="renewModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="renewModalLabel">تمدید کاربر</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="renewUserForm">
                    <div class="modal-body">
                        <input type="hidden" id="renewUsername" name="renewUsername">
                        <div class="form-group">
                            <label for="renewDataLimit">حجم جدید (GB):</label>
                            <select id="renewDataLimit" class="form-control" name="renewDataLimit">
                                <?php for ($i = 10; $i <= 100; $i += 10) { echo "<option value='$i'>$i GB</option>"; } ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="renewExpire">تاریخ انقضا:</label>
                            <select id="renewExpire" class="form-control" name="renewExpire">
                                <option value="1">یک ماهه</option>
                                <option value="2">دو ماهه</option>
                                <option value="3">سه ماهه</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                        <button type="submit" class="btn btn-primary">تمدید</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Buy Extra Data Modal -->
    <div class="modal fade" id="extraDataModal" tabindex="-1" role="dialog" aria-labelledby="extraDataModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="extraDataModalLabel">خرید حجم اضافه</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="extraDataForm">
                    <div class="modal-body">
                        <input type="hidden" id="extraDataUsername" name="username">
                        <div class="form-group">
                            <label for="extraDataLimit">حجم (GB):</label>
                            <select id="extraDataLimit" name="data_limit" class="form-control">
                                <?php for ($i = 5; $i <= 100; $i += 5) {
                                    echo "<option value='$i'>$i GB</option>";
                                } ?>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                        <button type="submit" class="btn btn-primary">تایید</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- QR Code Popup -->
    <div class="modal fade" id="qrCodePopup" tabindex="-1" role="dialog" aria-labelledby="qrCodePopupLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="qrCodePopupLabel">کد QR</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="qrCodeImage" src="" alt="QR Code">
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>

<script>
    $(document).ready(function() {
        $('#priceTableModal').on('show.bs.modal', function () {
            $('#rulesModal').modal('hide');
        });

        $('#rulesModal').on('show.bs.modal', function () {
            $('#priceTableModal').modal('hide');
        });

        loadTable(1);

        function loadTable(page) {
            $.ajax({
                url: "fetch_data.php",
                type: "GET",
                data: { page: page },
                success: function(response) {
                    console.log("Table data loaded", response);
                    var data = JSON.parse(response);
                    var users = data.users;
                    var total_pages = data.total_pages;
                    var tableBody = '';
                    for (var i = 0; i < users.length; i++) {
                        var user = users[i];
                        var usagePercentage = (user.used_traffic / user.data_limit) * 100;
                        var statusClass = user.status === 'active' ? 'status-active' : 'status-disabled';
                        tableBody += `
                            <tr>
                                <td><i class="${getOnlineStatusClass(user.online_at)}"></i> ${user.username}
                                    <small class="custom-style" id="timeAgo_${user.id}">${getTimeAgo(user.online_at)}</small>
                                </td>
                                <td><p class="status-badge ${statusClass}">${user.status}</p>
                                    <small class="custom-style">${getDaysRemaining(user.expire)} days remaining</small>
                                </td>
                                <td>
                                    <div class="progress">
                                        <div class="progress-bar ${getProgressBarColor(usagePercentage)}" role="progressbar" style="width: ${usagePercentage}%" aria-valuenow="${usagePercentage}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                    <small>${formatBytes(user.used_traffic)} / ${formatBytes(user.data_limit)}</small>
                                </td>
                                <td>
                                    <button class="btn btn-info btn-sm subscription-btn" data-username="${user.username}">Get Subscription Link</button>
                                    <span class="qr_btn"></span>
                                </td>
                                <td>
                                    <button class="btn btn-info btn-sm" onclick="showDetailsPopup('${user.username}')">جزئیات</button>
                                    <button class="btn btn-info btn-sm" onclick="toggleUserStatus('${user.username}', '${user.status}')">${user.status === 'active' ? 'غیرفعال کردن' : 'فعال کردن'}</button>
                                    <button class="btn btn-primary btn-sm" onclick="openRenewModal('${user.username}')">تمدید</button>
                                    <button class="btn btn-secondary btn-sm" onclick="openExtraDataModal('${user.username}')">خرید حجم اضافه</button>
                                </td>
                            </tr>
                        `;
                    }
                    $('#tableBody').html(tableBody);

                    var pagination = '';
                    for (var i = 1; i <= total_pages; i++) {
                        pagination += `<li class="page-item ${i === page ? 'active' : ''}"><a class="page-link" href="#" onclick="loadTable(${i})">${i}</a></li>`;
                    }
                    $('#pagination').html(`<ul class="pagination">${pagination}</ul>`);

                    // Attach event handlers for subscription buttons
                    $('.subscription-btn').click(function() {
                        var username = $(this).data('username');
                        getSubscriptionUrl(username);
                    });

                    // بعد از 60 ثانیه وضعیت آنلاین بودن کاربران را بررسی کنید
                    setTimeout(checkOnlineStatus, 10000);


                },
                error: function(xhr, status, error) {
                    console.error('Error loading table:', error);
                }
            });
        }

        function checkOnlineStatus() {
            $.ajax({
                url: "fetch_data.php",
                type: "GET",
                data: { check_status: 1 },
                success: function(response) {
                    console.log("Updated user data with online status", response);
                    var data = JSON.parse(response);
                    var users = data.users;
                    // به‌روزرسانی رابط کاربری با وضعیت آنلاین
                    updateUI(users);
                },
                error: function(xhr, status, error) {
                    console.error('Error checking online status:', error);
                }
            });
        }

        function updateUI(users) {
            users.forEach(user => {
                console.log(`User: ${user.username}, Online: ${user.is_online}`);
                // به‌روزرسانی DOM یا جدول کاربران با وضعیت جدید آنلاین بودن
                var userRow = $(`#tableBody tr:contains(${user.username})`);
                if (user.is_online) {
                    userRow.find('i').attr('class', 'circle pulse green');
                    userRow.find(`#timeAgo_${user.id}`).text('Online');
                } else {
                    userRow.find('i').attr('class', 'circle pulse red');
                    userRow.find(`#timeAgo_${user.id}`).text(getTimeAgo(user.online_at));
                }
            });
        }

        function getProgressBarColor(percentage) {
            if (percentage <= 30) return 'bg-success';
            if (percentage <= 70) return 'bg-warning';
            return 'bg-danger';
        }

        function getOnlineStatusClass(onlineAt) {
            var timeDiff = new Date() - new Date(onlineAt);
            if (onlineAt === '') return 'circle pulse orange';
            if (timeDiff <= 60000) return 'circle pulse green';
            return 'circle pulse red';
        }

        function getTimeAgo(onlineAt) {
            if (!onlineAt || isNaN(new Date(onlineAt))) {
                return 'Never connected';
            }

            var timeDiff = (new Date() - new Date(onlineAt)) / 1000;
            if (timeDiff <= 60) return 'Online';
            if (timeDiff <= 3600) return `${Math.floor(timeDiff / 60)} minutes ago`;
            if (timeDiff <= 86400) return `${Math.floor(timeDiff / 3600)} hours ago`;
            return `${Math.floor(timeDiff / 86400)} days ago`;
        }

        function getDaysRemaining(expireTimestamp) {
            var currentTimestamp = Math.floor(Date.now() / 1000);
            var remainingSeconds = expireTimestamp - currentTimestamp;
            return Math.max(0, Math.floor(remainingSeconds / (60 * 60 * 24)));
        }

        function formatBytes(bytes) {
            if (bytes >= 1073741824) return (bytes / 1073741824).toFixed(2) + ' GB';
            if (bytes >= 1048576) return (bytes / 1048576).toFixed(2) + ' MB';
            if (bytes >= 1024) return (bytes / 1024).toFixed(2) + ' KB';
            return bytes + ' B';
        }

        function updateWalletBalance() {
            $.ajax({
                url: 'get_wallet_balance.php',
                type: 'GET',
                success: function(response) {
                    var data = JSON.parse(response);
                    if (data.status === 'success') {
                        $('#walletBalance').text(data.wallet_balance);
                    } else {
                        alert('Failed to update wallet balance');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error updating wallet balance:', error);
                }
            });
        }

        window.loadTable = loadTable; // Expose the function to global scope

        window.toggleUserStatus = function(username, currentStatus) {
            console.log(`Sending toggle status request for user: ${username} current status: ${currentStatus}`);
            $.ajax({
                url: 'toggle_status.php',
                type: 'POST',
                data: {
                    username: username,
                    status: currentStatus
                },
                success: function(response) {
                    console.log('Response from server:', response);
                    try {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            loadTable(1);
                            updateWalletBalance();
                        } else {
                            alert('Failed to update user status');
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                    }
                }
            });
        };

        $('#createUserForm').submit(function(event) {
            event.preventDefault();
            $('#loader').show();
            $.ajax({
                url: 'create_user.php',
                type: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    $('#loader').hide();
                    try {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: data.message
                            });
                            $('#createUserForm')[0].reset();
                            loadTable(1);
                            updateWalletBalance();
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: data.message
                            });
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error creating user:', error);
                }
            });
        });

        window.getSubscriptionUrl = function(username) {
            console.log(`Fetching subscription URL for user: ${username}`);
            $.ajax({
                url: "get_subscription_url.php",
                type: "POST",
                data: { username: username },
                success: function(response) {
                    console.log(`Response from server for user: ${username}`, response);
                    try {
                        var data = JSON.parse(response);
                        console.log(`Parsed data for user: ${username}`, data);
                        var button = $(`button[data-username='${username}']`);
                        var qrBtnSpan = button.next('.qr_btn');
                        if (data.subscription_url) {
                            console.log(`Subscription URL found for user: ${username}`);
                            button.html('Copy').off('click').click(function() {
                                console.log(`Copy button clicked for user: ${username}`);
                                copyToClipboard(data.subscription_url);
                            });
                            qrBtnSpan.html(`<button class="qr-code-icon btn btn-info btn-sm" data-url="${data.subscription_url}">QR Code</button>`);
                            qrBtnSpan.find('.qr-code-icon').off('click').on('click', function() {
                                console.log(`QR Code button clicked for user: ${username}`);
                                var url = $(this).data('url');
                                $('#qrCodeImage').attr('src', `https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=${url}`);
                                $('#qrCodePopup').modal('show');
                            });
                        } else {
                            console.log(`Subscription URL not found for user: ${username}`);
                            button.html("N/A");
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                    }
                },
                error: function(xhr, status, error) {
                    console.error(`Error fetching subscription URL for user: ${username}`, error);
                }
            });
        };

        window.copyToClipboard = function(url) {
            var textarea = document.createElement("textarea");
            textarea.value = url;
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand("copy");
            document.body.removeChild(textarea);
            alert("Subscription link copied to clipboard!");
        };

        window.showDetailsPopup = function(username) {
            console.log(`Fetching details for user: ${username}`);
            $.ajax({
                url: 'fetch_user_details.php',
                type: 'POST',
                data: { username: username },
                success: function(response) {
                    console.log('Response from server:', response);
                    try {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            $('#modalSubRevokedAt').text(data.data.sub_revoked_at);
                            $('#modalNote').text(data.data.note);
                            $('#modalSubUpdatedAt').text(data.data.sub_updated_at);
                            $('#modalSubLastUserAgent').text(data.data.sub_last_user_agent);
                            $('#modalOnlineAt').text(data.data.online_at);
                            $('#modalExpire').text(new Date(data.data.expire * 1000).toLocaleString());
                            $('#modalCreatedAt').text(new Date(data.data.created_at).toLocaleString());
                            $('#detailsModal').modal('show');
                        } else {
                            alert('Failed to fetch user details');
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching user details:', error);
                }
            });
        };

        window.openRenewModal = function(username) {
            $('#renewUsername').val(username);
            $('#renewModal').modal('show');
        };

        $('#renewUserForm').submit(function(event) {
            event.preventDefault();
            $('#loader').show();
            $.ajax({
                url: 'renew_user.php',
                type: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    $('#loader').hide();
                    try {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: data.message
                            });
                            $('#renewUserForm')[0].reset();
                            loadTable(1);
                            updateWalletBalance();
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: data.message
                            });
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error renewing user:', error);
                }
            });
        });

        window.openExtraDataModal = function(username) {
            $('#extraDataUsername').val(username);
            $('#extraDataModal').modal('show');
        };

        $('#extraDataForm').submit(function(event) {
            event.preventDefault();
            $('#loader').show();
            $.ajax({
                url: 'buy_extra_data.php',
                type: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    $('#loader').hide();
                    try {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: data.message
                            });
                            $('#extraDataForm')[0].reset();
                            loadTable(1);
                            updateWalletBalance();
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: data.message
                            });
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error buying extra data:', error);
                }
            });
        });

        window.toggleMode = function() {
            var body = document.body;
            var table = document.getElementById('usersTable');
            body.classList.toggle('dark-mode');
            body.classList.toggle('light-mode');
            table.classList.toggle('table-dark');
        };

        window.addEventListener('load', function() {
            const options = {
                bottom: '64px', // Default: '32px'
                right: '32px', // Default: '32px'
                left: 'unset', // Default: 'unset'
                time: '0.5s', // Default: '0.3s'
                mixColor: '#fff', // Default: '#fff'
                backgroundColor: '#fff',  // Default: '#fff'
                buttonColorDark: '#fff',  // Default: '#100f2c'
                buttonColorLight: '#fff', // Default: '#fff'
                saveInCookies: false, // Default: true,
                label: '🌓', // Default: ''
                autoMatchOsTheme: true // Default: true
            }

            const darkmode = new Darkmode(options);
            darkmode.showWidget();
        });

        // Attach event handler for create test account button
        $('#createTestAccountBtn').click(function() {
            createTestAccount();
        });

        // Define the function to create a test account
        function createTestAccount() {
            $.ajax({
                url: 'create_test_account.php',
                type: 'POST',
                data: { action: 'create_test_account' },
                success: function(response) {
                    try {
                        var data = JSON.parse(response);
                        if (data.status === 'success') {
                            Swal.fire({
                                icon: 'success',
                                title: 'اکانت تست با موفقیت ساخته شد.',
                                text: data.message
                            });
                            loadTable(1);
                            updateWalletBalance(); // Update wallet balance after creating test account
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: data.message
                            });
                        }
                    } catch (e) {
                        console.error('Error parsing JSON response:', e);
                        Swal.fire({
                            icon: 'error',
                            title: 'خطا در تجزیه پاسخ سرور'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error creating test account:', error);
                    Swal.fire({
                        icon: 'error',
                        title: 'خطا در ایجاد اکانت تست'
                    });
                }
            });
        }
    });
</script>


</body>
</html>
