include 'db.php'; // اتصال به دیتابیس
include 'functions.php'; // وارد کردن سایر توابع

// مقادیر تست برای ثبت لاگ
$user = [
    'id' => 1, // مقدار تست
    'login_username' => 'testuser' // مقدار تست
];
$action = 'test_action';
$description = 'This is a test log entry';
$current_balance = 1000;
$new_balance = 900;
$amount_deducted = 100;
$data_volume = 1073741824; // 1GB
$expire_time = time() + 3600;
$user_status = 'active';

// Insert log into database
$stmt = $pdo->prepare("INSERT INTO logs (user_id, action, description, current_balance, new_balance, amount_deducted, data_volume, expire_time, user_status) VALUES (:user_id, :action, :description, :current_balance, :new_balance, :amount_deducted, :data_volume, :expire_time, :user_status)");
$stmt->execute([
    'user_id' => $user['id'],
    'action' => $action,
    'description' => $description,
    'current_balance' => $current_balance,
    'new_balance' => $new_balance,
    'amount_deducted' => $amount_deducted,
    'data_volume' => $data_volume,
    'expire_time' => $expire_time,
    'user_status' => $user_status
]);

// Prepare log message
$log_message = "ID: {$pdo->lastInsertId()}\n";
$log_message .= "Username: {$user['login_username']}\n";
$log_message .= "Action: $action\n";
$log_message .= "Description: $description\n";
$log_message .= "Current Balance: $current_balance\n";
$log_message .= "New Balance: $new_balance\n";
$log_message .= "Amount Deducted: $amount_deducted\n";
$log_message .= "Data Volume: " . bytesToGigabytes($data_volume) . "\n";
$log_message .= "Expire Time: " . ($expire_time ? date('Y-m-d H:i:s', $expire_time) : 'N/A') . "\n";
$log_message .= "User Status: $user_status\n";
$log_message .= "Created At: " . date('Y-m-d H:i:s');

// Send log message to Telegram
sendTelegramMessage($log_message);
