<?php
session_start();
include 'db.php'; // اتصال به دیتابیس

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_username = $_POST['login_username'];
    $login_password = $_POST['login_password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE login_username = :login_username");
    $stmt->execute(['login_username' => $login_username]);
    $user = $stmt->fetch();

    if ($user && password_verify($login_password, $user['login_password'])) {
        $_SESSION['user'] = $user;
        $_SESSION['admin_id'] = $user['admin_id']; // اضافه کردن admin_id به سشن
        header('Location: index.php');
        exit();
    } else {
        $message = "Invalid username or password";
    }
}
?>

<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>ورود به سیستم</title>

    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #121212;
            color: #e0e0e0;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .login-container {
            background: #1e1e1e;
            padding: 2rem;
            border-radius: 0.5rem;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.5);
        }
        .login-container h1 {
            margin-bottom: 1.5rem;
        }
        .login-container .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
        }
        .login-container .btn-primary:hover {
            background-color: #0056b3;
            border-color: #004085;
        }
        .form-control {
            background-color: #2b2b2b;
            border: 1px solid #3a3a3a;
            color: #e0e0e0;
        }
        .form-control:focus {
            background-color: #2b2b2b;
            color: #e0e0e0;
        }
        .alert {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <?php if (!empty($message)) { echo "<div class='alert alert-danger'>$message</div>"; } ?>
        <form method="post" action="">
            <div class="form-group">
                <label for="login_username">username</label>
                <input type="text" id="login_username" name="login_username" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="login_password">password:</label>
                <input type="password" id="login_password" name="login_password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-primary btn-block">Login</button>
        </form>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.4/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
