<?php
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

$admin_id = $_SESSION['admin_id'];

$servername = "147.45.138.167";
$port = 3306;
$username = "root";
$password = "M435fdg546Fgfh";
$dbname = "marzban";

try {
    // ایجاد اتصال PDO
    $dsn = "mysql:host=$servername;port=$port;dbname=$dbname;charset=utf8mb4";
    $options = [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES   => false,
    ];
    $pdo = new PDO($dsn, $username, $password, $options);

    // تعیین تعداد رکوردها در هر صفحه
    $limit = 30;
    if (isset($_GET["page"])) {
        $page = $_GET["page"];
    } else {
        $page = 1;
    }
    $start_from = ($page - 1) * $limit;

    // بررسی پارامتر check_status
    $check_status = isset($_GET['check_status']) ? $_GET['check_status'] : 0;

    if ($check_status == 0) {
        // اجرای کوئری برای دریافت وضعیت اولیه کاربران
        $stmt = $pdo->prepare("SELECT 
                                    id,
                                    username,
                                    status,
                                    used_traffic,
                                    data_limit,
                                    expire,
                                    created_at,
                                    sub_revoked_at,
                                    note,
                                    sub_updated_at,
                                    sub_last_user_agent,
                                    online_at
                                FROM 
                                    users
                                WHERE 
                                    admin_id = :admin_id
                                ORDER BY 
                                    created_at DESC
                                LIMIT :start_from, :limit");
        $stmt->bindParam(':admin_id', $admin_id, PDO::PARAM_INT);
        $stmt->bindParam(':start_from', $start_from, PDO::PARAM_INT);
        $stmt->bindParam(':limit', $limit, PDO::PARAM_INT);
        $stmt->execute();
        $users = $stmt->fetchAll();

        // محاسبه تعداد کل رکوردها
        $stmt_total = $pdo->prepare("SELECT COUNT(*) FROM users WHERE admin_id = :admin_id");
        $stmt_total->bindParam(':admin_id', $admin_id, PDO::PARAM_INT);
        $stmt_total->execute();
        $total_records = $stmt_total->fetchColumn();
        $total_pages = ceil($total_records / $limit);

        // ذخیره وضعیت اولیه مصرف ترافیک در سشن برای استفاده در درخواست دوم
        $_SESSION['initialTraffic'] = array_column($users, 'used_traffic', 'id');

        $data = [
            'users' => $users,
            'total_pages' => $total_pages,
        ];

        echo json_encode($data);
    } else {
        // اجرای کوئری برای دریافت وضعیت جدید کاربران
        $stmt = $pdo->prepare("SELECT 
                                    id,
                                    username,
                                    status,
                                    used_traffic,
                                    data_limit,
                                    expire,
                                    created_at,
                                    sub_revoked_at,
                                    note,
                                    sub_updated_at,
                                    sub_last_user_agent,
                                    online_at
                                FROM 
                                    users
                                WHERE 
                                    admin_id = :admin_id
                                ORDER BY 
                                    created_at DESC");
        $stmt->bindParam(':admin_id', $admin_id, PDO::PARAM_INT);
        $stmt->execute();
        $updatedUsers = $stmt->fetchAll();

        // الگوریتم بررسی تغییر مصرف ترافیک کاربران
        $initialTraffic = $_SESSION['initialTraffic'];
        foreach ($updatedUsers as &$user) {
            $id = $user['id'];
            if (isset($initialTraffic[$id])) {
                if ($user['used_traffic'] > $initialTraffic[$id]) {
                    $user['is_online'] = true;
                } else {
                    $user['is_online'] = false;
                }
            } else {
                $user['is_online'] = false;
            }
        }

        $data = [
            'users' => $updatedUsers,
        ];

        echo json_encode($data);
    }

} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>
