<?php

include 'db.php'; // اتصال به دیتابیس










function log_message($message) {
    $log_file = 'log.txt';
    $current_time = date('Y-m-d H:i:s');
    file_put_contents($log_file, $current_time . " - " . $message . "\n", FILE_APPEND);
}






function token_panel($url_panel, $username_panel, $password_panel) {
    $url_get_token = $url_panel . '/api/admin/token';
    $data_token = array(
        'username' => $username_panel,
        'password' => $password_panel
    );
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_TIMEOUT_MS => 3000,
        CURLOPT_POSTFIELDS => http_build_query($data_token),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
            'accept: application/json'
        )
    );
    $curl_token = curl_init($url_get_token);
    curl_setopt_array($curl_token, $options);
    $token = curl_exec($curl_token);
    if (curl_error($curl_token)) {
        $token = [];
        $token['error'] = curl_error($curl_token);
        return $token;
    }
    curl_close($curl_token);

    $body = json_decode($token, true);
    return $body;
}


function get_users($base_url, $admin_username, $admin_password) {
    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        echo "Error: " . $token_data['error'];
        return null;
    }

    $url = $base_url . "/api/users";
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json',
            'Authorization: Bearer ' . $token_data['access_token']
        )
    );

    $ch = curl_init($url);
    curl_setopt_array($ch, $options);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
        return null;
    }

    curl_close($ch);

    return json_decode($response, true);
}



function delete_user($base_url, $admin_username, $admin_password, $username_to_delete) {
    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        echo "Error: " . $token_data['error'];
        return false;
    }

    $url = $base_url . "/api/user/" . $username_to_delete;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "DELETE");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: Bearer ' . $token_data['access_token']
    ));

    $response = curl_exec($ch);
    if ($response === FALSE) {
        echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);
        return false;
    }

    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpcode >= 200 && $httpcode < 300) {
        return true;
    } else {
        echo 'HTTP error: ' . $httpcode . ' - Response: ' . $response;
        return false;
    }
}



function modify_user($base_url, $admin_username, $admin_password, $username_to_modify, $user_data) {
    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        echo "Error: " . $token_data['error'];
        return null;
    }

    $url = $base_url . "/api/user/" . $username_to_modify;
    $payload = json_encode($user_data);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: Bearer ' . $token_data['access_token'],
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    $response = curl_exec($ch);
    if ($response === FALSE) {
        echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);
        return null;
    }

    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpcode >= 200 && $httpcode < 300) {
        return true;
    } else {
        echo 'HTTP error: ' . $httpcode . ' - Response: ' . $response;
        return false;
    }
}

function get_user($base_url, $admin_username, $admin_password, $username) {
    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        echo "Error: " . $token_data['error'];
        return null;
    }

    $url = $base_url . "/api/user/" . $username;
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            'Accept: application/json',
            'Authorization: Bearer ' . $token_data['access_token']
        )
    );

    $ch = curl_init($url);
    curl_setopt_array($ch, $options);
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
        return null;
    }

    curl_close($ch);

    return json_decode($response, true);
}




/*

function send_request_with_delay($url, $data, $delay = 1) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));
    $response = curl_exec($ch);
    curl_close($ch);
    sleep($delay);
    return $response;
}


*/


function reset_user_data_usage($base_url, $admin_username, $admin_password, $username) {
    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        echo "Error: " . $token_data['error'];
        return false;
    }

    $url = $base_url . "/api/user/" . $username . "/reset";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Bearer ' . $token_data['access_token'],
        'Accept: application/json'
    ));

    $response = curl_exec($ch);
    if ($response === FALSE) {
        echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);
        return false;
    }

    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpcode >= 200 && $httpcode < 300) {
        return true;
    } else {
        echo 'HTTP error: ' . $httpcode . ' - Response: ' . $response;
        return false;
    }
}


function add_user($base_url, $admin_username, $admin_password, $new_user_data) {
    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        echo "Error: " . $token_data['error'];
        return null;
    }

    $url = $base_url . "/api/user";
    $payload = json_encode($new_user_data);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Authorization: Bearer ' . $token_data['access_token'],
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    $response = curl_exec($ch);
    if ($response === FALSE) {
        echo 'Curl error: ' . curl_error($ch);
        curl_close($ch);
        return null;
    }

    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($httpcode >= 400) {
        echo 'HTTP error: ' . $httpcode . ' - Response: ' . $response;
    }

    curl_close($ch);

    return json_decode($response, true);
}

function renew_user($base_url, $admin_username, $admin_password, $username, $data_limit, $expire) {
    log_message("Renew user process started for $username");

    $token_data = token_panel($base_url, $admin_username, $admin_password);

    if (isset($token_data['error'])) {
        log_message("Error getting token: " . $token_data['error']);
        return false;
    }

    log_message("Token received: " . json_encode($token_data));

    // Reset user data usage
    if (!reset_user_data_usage($base_url, $admin_username, $admin_password, $username)) {
        log_message("Error resetting user data usage.");
        return false;
    }

    log_message("User data usage reset successful for $username");

    // Update user data limit, expire, and status
    $url = $base_url . "/api/user/" . $username;
    $payload = json_encode(array(
        'data_limit' => $data_limit,
        'expire' => intval($expire),
        'status' => 'active'  // Set status to active
    ));

    log_message("Payload to send: " . $payload);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Bearer ' . $token_data['access_token'],
        'Content-Type: application/json'
    ));
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    $response = curl_exec($ch);
    if ($response === FALSE) {
        log_message('Curl error: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }

    log_message("Response received: " . $response);

    $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    log_message("HTTP code: " . $httpcode);

    if ($httpcode >= 200 && $httpcode < 300) {
        log_message("Renew user process successful for $username");
        return true;
    } else {
        log_message('HTTP error: ' . $httpcode . ' - Response: ' . $response);
        return false;
    }
}

function buy_extra_data($base_url, $admin_username, $admin_password, $username, $extra_data_limit) {
    // دریافت اطلاعات فعلی یوزر
    $user_details = get_user($base_url, $admin_username, $admin_password, $username);
    $current_data_limit = $user_details['data_limit'];

    // اضافه کردن حجم جدید به حجم فعلی
    $new_data_limit = $current_data_limit + $extra_data_limit;

    // به‌روزرسانی اطلاعات یوزر
    return modify_user($base_url, $admin_username, $admin_password, $username, [
        'data_limit' => $new_data_limit,
        'status' => 'active'
    ]);
}



// functions.php

function get_user_subscription_url($url_panel, $token, $username) {
    $url_get_user = $url_panel . '/api/user/' . $username;
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . $token,
            'accept: application/json'
        )
    );
    $curl_user = curl_init($url_get_user);
    curl_setopt_array($curl_user, $options);
    $user_data = curl_exec($curl_user);
    if (curl_error($curl_user)) {
        file_put_contents('user_error_log.txt', curl_error($curl_user), FILE_APPEND);
        return null;
    }
    curl_close($curl_user);

    $body = json_decode($user_data, true);
    file_put_contents('user_data_log.txt', "URL: $url_get_user\n" . print_r($body, true), FILE_APPEND);
    return $body['subscription_url'] ?? null;
}




/*-----------------------------------------------------------*/



function sendTelegramMessage($message) {
    $telegram_api_token = '7454890245:AAFMhZfrGENbKX5DO10CBo68EQuC-9QPbck';
    $chat_id = '6749451717';

    $url = "https://api.telegram.org/bot$telegram_api_token/sendMessage";

    $data = [
        'chat_id' => $chat_id,
        'text' => $message,
        'parse_mode' => 'HTML' // اضافه کردن parse_mode به داده‌ها

    ];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
        ],
    ];
    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);

    if ($result === FALSE) {
        error_log("Failed to send message to Telegram.");
    } else {
        error_log("Message sent to Telegram: " . $message);
    }
}



function get_user_info_from_api($base_url, $admin_username, $admin_password, $username) {
    // این تابع باید با استفاده از اطلاعات پنل به API خارجی متصل شده و اطلاعات یوزرنیم را دریافت کند
    $url = $base_url . '/api/user_info';
    $data = [
        'username' => $admin_username,
        'password' => $admin_password,
        'target_user' => $username
    ];

    $options = [
        'http' => [
            'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($data),
        ],
    ];
    $context  = stream_context_create($options);
    $result = file_get_contents($url, false, $context);

    if ($result === FALSE) { 
        return null; 
    }

    return json_decode($result, true);
}






function bytesToGigabytes($bytes) {
    return round($bytes / (1024 * 1024 * 1024), 2);
}
?>
