<?php
session_start();

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}



include 'db.php'; // اتصال به دیتابیس داخلی

// چک کردن سشن کاربر لاگین شده
if (!isset($_SESSION['user'])) {
    echo json_encode(['error' => 'User not logged in']);
    exit();
}

$user_id = $_SESSION['user']['id'];

function token_panel($url_panel, $username_panel, $password_panel) {
    $url_get_token = $url_panel . '/api/admin/token';
    $data_token = array(
        'username' => $username_panel,
        'password' => $password_panel
    );
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_TIMEOUT_MS => 3000,
        CURLOPT_POSTFIELDS => http_build_query($data_token),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded',
            'accept: application/json'
        )
    );
    $curl_token = curl_init($url_get_token);
    curl_setopt_array($curl_token, $options);
    $token = curl_exec($curl_token);
    if (curl_error($curl_token)) {
        file_put_contents('token_error_log.txt', curl_error($curl_token), FILE_APPEND);
        return null;
    }
    curl_close($curl_token);

    $body = json_decode($token, true);
    file_put_contents('token_log.txt', print_r($body, true), FILE_APPEND);
    return $body['access_token'] ?? null;
}

function get_user_subscription_url($url_panel, $token, $username) {
    $url_get_user = $url_panel . '/api/user/' . $username;
    $options = array(
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . $token,
            'accept: application/json'
        )
    );
    $curl_user = curl_init($url_get_user);
    curl_setopt_array($curl_user, $options);
    $user_data = curl_exec($curl_user);
    if (curl_error($curl_user)) {
        file_put_contents('user_error_log.txt', curl_error($curl_user), FILE_APPEND);
        return null;
    }
    curl_close($curl_user);

    $body = json_decode($user_data, true);
    file_put_contents('user_data_log.txt', "URL: $url_get_user\n" . print_r($body, true), FILE_APPEND);
    return $body['subscription_url'] ?? null;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? null;

    if ($username) {
        // واکشی اطلاعات پنل از دیتابیس داخلی
        $stmt = $pdo->prepare("SELECT panel_url, panel_username, panel_password FROM users WHERE id = :user_id");
        $stmt->execute(['user_id' => $user_id]);
        $user_panel_data = $stmt->fetch();

        if ($user_panel_data) {
            $url_panel = $user_panel_data['panel_url'];
            $username_panel = $user_panel_data['panel_username'];
            $password_panel = $user_panel_data['panel_password'];

            $token = token_panel($url_panel, $username_panel, $password_panel);
            if ($token) {
                $subscription_url = get_user_subscription_url($url_panel, $token, $username);
                if ($subscription_url) {
                    echo json_encode(['subscription_url' => $subscription_url]);
                    exit;
                }
            }
        }
    }

    echo json_encode(['error' => 'Unable to retrieve subscription URL.']);
}
?>
