<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}


if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}



include 'db.php';
include 'functions.php';

if (!isset($_SESSION['user'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not authenticated']);
    exit();
}

$user = $_SESSION['user'];
$base_url = $user['panel_url'];
$admin_username = $user['panel_username'];
$admin_password = $user['panel_password'];
$admin_login_username = $user['login_username']; // فرض می‌کنیم login_username در سشن ذخیره شده است

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['renewUsername'];
    $data_limit_gb = intval($_POST['renewDataLimit']);
    $expireMonths = intval($_POST['renewExpire']);
    $expireDate = new DateTime();
    $expireDate->modify("+$expireMonths months");
    $expireUTC = $expireDate->getTimestamp();

    // جدول قیمت‌ها برای سه پلن مشخص
    $pricing_table = [
        10 => [
            1 => 20000, // 10 گیگابایت، 1 ماه، 20000 تومان
            2 => 40000, // 10 گیگابایت، 2 ماه، 40000 تومان
            3 => 60000, // 10 گیگابایت، 3 ماه، 60000 تومان
        ],
        20 => [
            1 => 25000, // 20 گیگابایت، 1 ماه، 25000 تومان
            2 => 50000, // 20 گیگابایت، 2 ماه، 50000 تومان
            3 => 75000, // 20 گیگابایت، 3 ماه، 75000 تومان
        ],
    ];

    if (isset($pricing_table[$data_limit_gb][$expireMonths])) {
        $total_cost = $pricing_table[$data_limit_gb][$expireMonths];
    } else {
        // فرمول محاسبه هزینه برای موارد دیگر
        $cost_per_gb_per_month = 1000;
        $total_cost = $data_limit_gb * $cost_per_gb_per_month * $expireMonths;
    }

    $gift_percentage = 0.05;
    $gift_amount = $total_cost * $gift_percentage;

    $stmt = $pdo->prepare("SELECT wallet_balance FROM users WHERE id = :user_id");
    $stmt->execute(['user_id' => $user['id']]);
    $wallet_balance = $stmt->fetchColumn();

    if ($wallet_balance >= $total_cost) {
        $pdo->beginTransaction();
        try {
            $new_wallet_balance = $wallet_balance - $total_cost + $gift_amount;
            $stmt = $pdo->prepare("UPDATE users SET wallet_balance = :new_wallet_balance WHERE id = :user_id");
            $stmt->execute(['new_wallet_balance' => $new_wallet_balance, 'user_id' => $user['id']]);

            $_SESSION['user']['wallet_balance'] = $new_wallet_balance;

            $result = renew_user($base_url, $admin_username, $admin_password, $username, $data_limit_gb * 1024 * 1024 * 1024, $expireUTC);

            if ($result) {
                $pdo->commit();
                $stmt = $pdo->prepare("INSERT INTO logs (user_id, action, description, current_balance, new_balance, amount_deducted, data_volume, expire_time, user_status) VALUES (:user_id, 'renew_user', :description, :current_balance, :new_balance, :amount_deducted, :data_volume, :expire_time, 'active')");
                $stmt->execute([
                    'user_id' => $user['id'],
                    'description' => 'User renewed with username: ' . $username,
                    'current_balance' => $wallet_balance,
                    'new_balance' => $new_wallet_balance,
                    'amount_deducted' => $total_cost,
                    'data_volume' => $data_limit_gb * 1024 * 1024 * 1024,
                    'expire_time' => $expireUTC
                ]);

                // ارسال پیام به تلگرام
                $statusEmoji = '✅';
                $message = "#renew_account\n"; // اضافه کردن هشتگ در ابتدای پیام
                $message .= "🔔 <b>ID:</b> " . $pdo->lastInsertId() . "\n";
                $message .= "👤 <b>Renewed By Admin:</b> #" . $admin_login_username . "\n";
                $message .= "👤 <b>Username:</b> #" . $username . "\n";
                $message .= "⚙️ <b>Action:</b> renew_user\n";
                $message .= "💰 <b>Current Balance:</b> " . number_format($wallet_balance, 0, '', ',') . "\n";
                $message .= "💳 <b>New Balance:</b> " . number_format($new_wallet_balance, 0, '', ',') . "\n";
                $message .= "💸 <b>Amount Deducted:</b> " . number_format($total_cost, 0, '', ',') . "\n";
                $message .= "🎁 <b>Gift Amount:</b> " . number_format($gift_amount, 0, '', ',') . "\n";
                $message .= "📊 <b>Data Volume:</b> " . number_format($data_limit_gb, 0) . " GB\n";
                $message .= "📅 <b>Expire Time:</b> " . date('Y-m-d H:i:s', $expireUTC) . "\n";
                $message .= "🔒 <b>User Status:</b> " . $statusEmoji . "\n";
                $message .= "⏰ <b>Renewed At:</b> " . date('Y-m-d H:i:s') . "\n";
                $message .= "📝 <b>Description:</b> User renewed with username: " . $username . "\n";

                sendTelegramMessage($message);

                echo json_encode([
                    'status' => 'success',
                    'message' => "موفقیت آمیز بود<br><small> مبلغ " . number_format($total_cost, 0, '', ',') . " تومان از کیف پول کسر شد<br> مبلغ " . number_format($gift_amount, 0, '', ',') . " تومان هم بعنوان هدیه به کیف پول شما بازگشت 🎁😊</small>"
                ]);
            } else {
                $pdo->rollBack();
                echo json_encode(['status' => 'error', 'message' => 'Failed to renew user']);
            }
        } catch (Exception $e) {
            $pdo->rollBack();
            echo json_encode(['status' => 'error', 'message' => 'Failed to renew user: ' . $e->getMessage()]);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'موجودی کافی نیست']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}


?>
