<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

include 'db.php';
include 'functions.php';

if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

$message = "";

// افزودن کاربر جدید
if (isset($_POST['add_user'])) {
    $login_username = $_POST['login_username'];
    $login_password = password_hash($_POST['login_password'], PASSWORD_BCRYPT);
    $panel_url = $_POST['panel_url'];
    $panel_username = $_POST['panel_username'];
    $panel_password = $_POST['panel_password'];
    $wallet_balance = $_POST['wallet_balance'];

    try {
        $stmt = $pdo->prepare("INSERT INTO users (login_username, login_password, panel_url, panel_username, panel_password, wallet_balance) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->execute([$login_username, $login_password, $panel_url, $panel_username, $panel_password, $wallet_balance]);
        $message = "User added successfully!";
    } catch (PDOException $e) {
        $message = "Error: " . $e->getMessage();
    }
}

// شارژ کیف پول
if (isset($_POST['charge_wallet'])) {
    $user_id = $_POST['user_id'];
    $amount = intval($_POST['amount']);

    try {
        // بروزرسانی موجودی کیف پول کاربر
        $stmt = $pdo->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?");
        $stmt->execute([$amount, $user_id]);

        // ثبت لاگ شارژ کیف پول
        $stmt = $pdo->prepare("INSERT INTO wallet_logs (user_id, amount) VALUES (?, ?)");
        $stmt->execute([$user_id, $amount]);

        $message = "Wallet charged successfully!";
    } catch (PDOException $e) {
        $message = "Error: " . $e->getMessage();
    }
}

// دریافت کاربران برای نمایش در فرم
$users = $pdo->query("SELECT id, login_username FROM users")->fetchAll(PDO::FETCH_ASSOC);

// دریافت لاگ‌های شارژ کیف پول
$stmt = $pdo->prepare("SELECT wallet_logs.*, users.login_username FROM wallet_logs JOIN users ON wallet_logs.user_id = users.id ORDER BY wallet_logs.created_at DESC");
$stmt->execute();
$logs = $stmt->fetchAll(PDO::FETCH_ASSOC);

// دریافت گزارشات درآمد
$dateIntervals = [
    'today' => 'امروز',
    'yesterday' => 'دیروز',
    'week' => 'یک هفته',
    'month' => 'یک ماه',
    'all' => 'کل'
];

$reports = [];

foreach ($dateIntervals as $interval => $label) {
    switch ($interval) {
        case 'today':
            $stmt = $pdo->prepare("SELECT SUM(amount_deducted) as total FROM logs WHERE DATE(created_at) = CURDATE()");
            break;
        case 'yesterday':
            $stmt = $pdo->prepare("SELECT SUM(amount_deducted) as total FROM logs WHERE DATE(created_at) = CURDATE() - INTERVAL 1 DAY");
            break;
        case 'week':
            $stmt = $pdo->prepare("SELECT SUM(amount_deducted) as total FROM logs WHERE DATE(created_at) >= CURDATE() - INTERVAL 7 DAY");
            break;
        case 'month':
            $stmt = $pdo->prepare("SELECT SUM(amount_deducted) as total FROM logs WHERE DATE(created_at) >= CURDATE() - INTERVAL 1 MONTH");
            break;
        case 'all':
            $stmt = $pdo->prepare("SELECT SUM(amount_deducted) as total FROM logs");
            break;
    }
    $stmt->execute();
    $total = $stmt->fetchColumn();
    $reports[$interval] = $total ? number_format($total, 0, '', ',') : 0;
}

// دریافت گزارش درآمد تک‌تک کاربران
$userReports = $pdo->query("
    SELECT 
        users.login_username, 
        SUM(logs.amount_deducted) as total_amount_deducted
    FROM users
    LEFT JOIN logs ON users.id = logs.user_id
    GROUP BY users.id
    ORDER BY total_amount_deducted DESC
")->fetchAll(PDO::FETCH_ASSOC);

?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>مدیریت کاربران و کیف پول</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5">
    <h1>مدیریت کاربران و کیف پول</h1>
    <?php if (!empty($message)): ?>
        <div class="alert alert-info"><?php echo $message; ?></div>
    <?php endif; ?>
    <ul class="nav nav-tabs" id="myTab" role="tablist">
        <li class="nav-item">
            <a class="nav-link active" id="add-user-tab" data-toggle="tab" href="#add-user" role="tab" aria-controls="add-user" aria-selected="true">افزودن کاربر جدید</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="charge-wallet-tab" data-toggle="tab" href="#charge-wallet" role="tab" aria-controls="charge-wallet" aria-selected="false">شارژ کیف پول</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="wallet-logs-tab" data-toggle="tab" href="#wallet-logs" role="tab" aria-controls="wallet-logs" aria-selected="false">سابقه شارژ کیف پول</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="income-report-tab" data-toggle="tab" href="#income-report" role="tab" aria-controls="income-report" aria-selected="false">گزارش درآمد</a>
        </li>
        <li class="nav-item">
            <a class="nav-link" id="user-income-report-tab" data-toggle="tab" href="#user-income-report" role="tab" aria-controls="user-income-report" aria-selected="false">گزارش درآمد کاربران</a>
        </li>
    </ul>
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="add-user" role="tabpanel" aria-labelledby="add-user-tab">
            <h2>افزودن کاربر جدید</h2>
            <form method="post">
                <div class="form-group">
                    <label for="login_username">نام کاربری:</label>
                    <input type="text" id="login_username" name="login_username" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="login_password">رمز عبور:</label>
                    <input type="password" id="login_password" name="login_password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="panel_url">آدرس پنل:</label>
                    <input type="text" id="panel_url" name="panel_url" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="panel_username">نام کاربری پنل:</label>
                    <input type="text" id="panel_username" name="panel_username" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="panel_password">رمز عبور پنل:</label>
                    <input type="password" id="panel_password" name="panel_password" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="wallet_balance">موجودی کیف پول:</label>
                    <input type="number" id="wallet_balance" name="wallet_balance" class="form-control" required>
                </div>
                <button type="submit" name="add_user" class="btn btn-primary">افزودن</button>
            </form>
        </div>
        <div class="tab-pane fade" id="charge-wallet" role="tabpanel" aria-labelledby="charge-wallet-tab">
            <h2>شارژ کیف پول</h2>
            <form method="post">
                <div class="form-group">
                    <label for="user_id">کاربر:</label>
                    <select id="user_id" name="user_id" class="form-control" required>
                        <?php foreach ($users as $user): ?>
                            <option value="<?php echo $user['id']; ?>"><?php echo htmlspecialchars($user['login_username']); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="amount">مبلغ (تومان):</label>
                    <input type="number" id="amount" name="amount" class="form-control" required>
                </div>
                <button type="submit" name="charge_wallet" class="btn btn-primary">شارژ</button>
            </form>
        </div>
        <div class="tab-pane fade" id="wallet-logs" role="tabpanel" aria-labelledby="wallet-logs-tab">
            <h2>سابقه شارژ کیف پول</h2>
            <table class="table table-striped table-dark">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>نام کاربری</th>
                    <th>مبلغ (تومان)</th>
                    <th>تاریخ</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($logs as $log): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($log['id']); ?></td>
                        <td><?php echo htmlspecialchars($log['login_username']); ?></td>
                        <td><?php echo number_format($log['amount']); ?> تومان</td>
                        <td><?php echo htmlspecialchars($log['created_at']); ?></td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="tab-pane fade" id="income-report" role="tabpanel" aria-labelledby="income-report-tab">
            <h2>گزارش درآمد</h2>
            <table class="table table-striped table-dark">
                <thead>
                <tr>
                    <th>بازه زمانی</th>
                    <th>مبلغ (تومان)</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($reports as $interval => $total): ?>
                    <tr>
                        <td><?php echo $dateIntervals[$interval]; ?></td>
                        <td><?php echo $total; ?> تومان</td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div class="tab-pane fade" id="user-income-report" role="tabpanel" aria-labelledby="user-income-report-tab">
            <h2>گزارش درآمد کاربران</h2>
            <table class="table table-striped table-dark">
                <thead>
                <tr>
                    <th>نام کاربری</th>
                    <th>مبلغ کل کسر شده (تومان)</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($userReports as $report): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($report['login_username']); ?></td>
                        <td><?php echo number_format($report['total_amount_deducted'], 0, '', ','); ?> تومان</td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
</body>
</html>
