<?php
session_start();
if (!isset($_SESSION['user'])) {
    header('Location: login.php');
    exit();
}

include 'db.php'; // اتصال به دیتابیس

$user = $_SESSION['user'];

try {
    // اجرای کوئری برای دریافت تراکنش‌ها
    $stmt = $pdo->prepare("SELECT * FROM logs WHERE user_id = :user_id ORDER BY created_at DESC");
    $stmt->execute(['user_id' => $user['id']]);
    $transactions = $stmt->fetchAll();
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
    exit();
}

function bytesToGigabytes($bytes) {
    if ($bytes === null) {
        return 'N/A';
    }
    return number_format($bytes / (1024 * 1024 * 1024), 2) . ' GB';
}
?>
<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <title>تراکنش‌های من</title>
    <link rel="stylesheet" href="https://bootswatch.com/4/cerulean/bootstrap.min.css">
    <style>
        body {
            background-color: #2c2f33;
            color: #fff;
            font-family: 'IRANSans', sans-serif;
        }
        .table-dark th, .table-dark td {
            color: #fff;
        }
        .container {
            max-width: 100%;
            padding: 20px;
        }
        table {
            width: 100%;
        }
    </style>
</head>
<body>
<div class="container mt-5">
    <h1>تراکنش‌های من</h1>
    <button class="btn btn-primary mb-3" id="toggleLanguageBtn">تغییر زبان</button>
    <table class="table table-striped table-dark" id="transactionsTable">
        <thead>
        <tr>
            <th>ID</th>
            <th>عملیات</th>
            <th>توضیحات</th>
            <th>موجودی فعلی</th>
            <th>موجودی جدید</th>
            <th>مبلغ کسر شده</th>
            <th>حجم داده</th>
            <th>زمان انقضا</th>
            <th>وضعیت کاربر</th>
            <th>تاریخ ایجاد</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($transactions as $transaction): ?>
            <tr>
                <td><?php echo htmlspecialchars($transaction['id']); ?></td>
                <td><?php echo htmlspecialchars($transaction['action']); ?></td>
                <td><?php echo htmlspecialchars($transaction['description']); ?></td>
                <td><?php echo number_format($transaction['current_balance']); ?></td>
                <td><?php echo number_format($transaction['new_balance']); ?></td>
                <td><?php echo number_format($transaction['amount_deducted']); ?></td>
                <td><?php echo htmlspecialchars(bytesToGigabytes($transaction['data_volume'])); ?></td>
                <td><?php echo htmlspecialchars($transaction['expire_time'] ? date('Y-m-d H:i:s', $transaction['expire_time']) : 'N/A'); ?></td>
                <td><?php echo htmlspecialchars($transaction['user_status'] === 'active' ? '✅' : '❌'); ?></td>
                <td><?php echo htmlspecialchars($transaction['created_at']); ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<script>
document.getElementById('toggleLanguageBtn').addEventListener('click', function() {
    var table = document.getElementById('transactionsTable');
    var rows = table.getElementsByTagName('tr');

    for (var i = 1; i < rows.length; i++) {
        var cells = rows[i].getElementsByTagName('td');
        if (cells.length > 0) {
            cells[1].innerText = translateAction(cells[1].innerText);
            cells[2].innerText = translateDescription(cells[2].innerText);
            cells[8].innerText = translateStatus(cells[8].innerText);
        }
    }
});

function translateAction(action) {
    switch (action) {
        case 'buy_extra_data':
            return 'خرید حجم اضافه';
        case 'toggle_status':
            return 'تغییر وضعیت';
        case 'create_user':
            return 'ایجاد کاربر';
        default:
            return action;
    }
}

function translateDescription(description) {
    return description.replace('Extra data bought for username:', 'خرید حجم اضافه برای کاربر:')
                      .replace('User status changed for username:', 'وضعیت کاربر تغییر یافت برای کاربر:')
                      .replace('User created with username:', 'کاربر ایجاد شد با نام کاربری:');
}

function translateStatus(status) {
    switch (status) {
        case '✅':
            return 'فعال';
        case '❌':
            return 'غیرفعال';
        default:
            return status;
    }
}
</script>
</body>
</html>
