<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

include 'db.php'; // اتصال به دیتابیس
include 'functions.php'; // وارد کردن سایر توابع

if (!isset($_SESSION['user'])) {
    echo json_encode(['status' => 'error', 'message' => 'User not authenticated']);
    exit();
}

$user = $_SESSION['user'];
$base_url = $user['panel_url'];
$admin_username = $user['panel_username'];
$admin_password = $user['panel_password'];
$admin_login_username = $user['login_username']; // فرض می‌کنیم login_username در سشن ذخیره شده است

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $status = $_POST['status'];
    $new_status = $status === 'active' ? 'disabled' : 'active';

    $user_data = array("status" => $new_status);
    $response = modify_user($base_url, $admin_username, $admin_password, $username, $user_data);

    if ($response) {
        $stmt = $pdo->prepare("INSERT INTO logs (user_id, action, description, current_balance, new_balance, amount_deducted, data_volume, expire_time, user_status) VALUES (:user_id, 'toggle_status', :description, :current_balance, :new_balance, :amount_deducted, :data_volume, :expire_time, :user_status)");
        $stmt->execute([
            'user_id' => $user['id'],
            'description' => 'User status changed for username: ' . $username . ' to ' . $new_status,
            'current_balance' => $_SESSION['user']['wallet_balance'], 
            'new_balance' => $_SESSION['user']['wallet_balance'], 
            'amount_deducted' => 0,
            'data_volume' => 0,
            'expire_time' => 0,
            'user_status' => $new_status
        ]);

        // ارسال پیام به تلگرام
        $statusEmoji = $new_status === 'active' ? '✅' : '❌';
        $message = "#change_status\n"; // اضافه کردن هشتگ در ابتدای پیام
        $message .= "🔔 <b>Action:</b> Toggle User Status\n";
        $message .= "👤 <b>Changed By Admin:</b> #" . $admin_login_username . "\n";
        $message .= "👤 <b>Username:</b> #" . $username . "\n";
        $message .= "⚙️ <b>New Status:</b> " . $new_status . " " . $statusEmoji . "\n";
        $message .= "⏰ <b>Changed At:</b> " . date('Y-m-d H:i:s') . "\n";
        $message .= "📝 <b>Description:</b> User status changed for username: " . $username . " to " . $new_status . "\n";

        sendTelegramMessage($message);

        echo json_encode(['status' => 'success', 'new_status' => $new_status]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update status']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
}


?>
